/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: USER_netX.c 12298 2018-08-09 12:16:48Z Robert $:

  Description:
    USER implemented os specific functions called by the cifX Toolkit.

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2018-07-24  Fixed file header and PC-Lint warnings
    2010-04-25  initial version

**************************************************************************************/

/* Standard includes */
#include <stdio.h>          /*lint !e451 !e537 : repeatly include */
#include <stdarg.h>         /*lint !e451 !e537 : repeatly include */

#include "cifXToolkit.h"
#include "WarmstartFile.h"

/*****************************************************************************/
/*! Returns the number of firmware files associated with the card/channel,
*   passed as argument.
*   \param ptDevInfo DeviceInfo including channel number, for which the
*                    firmware file count should be read
*   \return number for firmware files, to download. The returned value will
*           be used as maximum value for ulIdx in calls to
*           USER_GetFirmwareFile                                             */
/*****************************************************************************/
uint32_t USER_GetFirmwareFileCount(PCIFX_DEVICE_INFORMATION ptDevInfo)
{
  return 0;
}

/*****************************************************************************/
/*! Returns firmware file information for the given device/channel and Idx
*   passed as argument.
*   \param ptDevInfo  DeviceInfo including channel number, for which the
*                     firmware file should be delivered
*   \param ulIdx      Index of the returned file
*                     (0..USER_GetFirmwareFileCount() - 1)
*   \param ptFileInfo Short and full file name of the firmware. Used in
*                     calls to OS_OpenFile()
*   \return !=0 on success                                                   */
/*****************************************************************************/
int USER_GetFirmwareFile(PCIFX_DEVICE_INFORMATION ptDevInfo, uint32_t ulIdx, PCIFX_FILE_INFORMATION ptFileInfo)
{
  return 0;
}

/*****************************************************************************/
/*! Returns the number of configuration files associated with the card/
*   channel, passed as argument.
*   \param ptDevInfo DeviceInfo including channel number, for which the
*                    configuration file count should be read
*   \return number for confgiuration files, to download. The returned value
*           will be used as maximum value for ulIdx in calls to
*           USER_GetConfgirationFile                                         */
/*****************************************************************************/
uint32_t USER_GetConfigurationFileCount(PCIFX_DEVICE_INFORMATION ptDevInfo)
{
  return 0;
}

/*****************************************************************************/
/*! Returns configuration file information for the given device/channel and
*   Idx passed as argument.
*   \param ptDevInfo  DeviceInfo including channel number, for which the
*                     configuration file should be delivered
*   \param ulIdx      Index of the returned file
*                     (0..USER_GetConfigurationFileCount() - 1)
*   \param ptFileInfo Short and full file name of the configuration. Used in
*                     calls to OS_OpenFile()
*   \return !=0 on success                                                   */
/*****************************************************************************/
int USER_GetConfigurationFile(PCIFX_DEVICE_INFORMATION ptDevInfo, uint32_t ulIdx, PCIFX_FILE_INFORMATION ptFileInfo)
{
  return 0;
}

/*****************************************************************************/
/*! Retrieve the full file name of the cifX Romloader binary image
*   \param ptDevInstance Pointer to the device instance
*   \param ptFileInfo Short and full file name of the bootloader. Used in
*                     calls to OS_OpenFile()
*   \return CIFX_NO_ERROR on success                                         */
/*****************************************************************************/
void USER_GetBootloaderFile(PDEVICEINSTANCE ptDevInstance, PCIFX_FILE_INFORMATION ptFileInfo)
{
    switch (ptDevInstance->eChipType)
    {
      case eCHIP_TYPE_NETX500:
      case eCHIP_TYPE_NETX100:
      {
        /* This is a netX100/500 device */
      }
      break;

      case eCHIP_TYPE_NETX50:
        /* This is a netX50 device */
      break;

      default:
        /* Unknown chip type */
        break;
    }
}

/*****************************************************************************/
/*! Retrieve the interrupt usage for the given device
*   \param ptDevInfo Device- and Serial number of the card
*   \return !=0 will make the device use IRQs                                */
/*****************************************************************************/
int USER_GetInterruptEnable(PCIFX_DEVICE_INFORMATION ptDevInfo)
{
  return 0;
}

/*****************************************************************************/
/*! Retrieve the alias name of a cifX Board depending on the Device and
*   Serialnumber passed during this call
*   \param ptDevInfo Device- and Serial number of the card
*   \param ulMaxLen  Maximum length of alias
*   \param szAlias   Buffer to copy alias to. A string of length 0 means
*                    no alias                                                */
/*****************************************************************************/
void USER_GetAliasName(PCIFX_DEVICE_INFORMATION ptDevInfo, uint32_t ulMaxLen, char* szAlias)
{
}

/*****************************************************************************/
/*! Returns OS file information for the given device/channel and Idx
*   passed as argument.
*   \param ptDevInfo  DeviceInfo including channel number, for which the
*                     firmware file should be delivered
*   \param ptFileInfo Short and full file name of the firmware. Used in
*                     calls to OS_OpenFile()
*   \return != 0 on success                                                   */
/*****************************************************************************/
int USER_GetOSFile(PCIFX_DEVICE_INFORMATION ptDevInfo, PCIFX_FILE_INFORMATION ptFileInfo)
{
  return 0;
}

/*****************************************************************************/
/*! Read the warm start data from a given warmstart file
*   \param ptDevInfo Device- and Serial number of the card
*   \param ptPacket  Buffer for the warm start packet                        */
/*****************************************************************************/
int USER_GetWarmstartParameters(PCIFX_DEVICE_INFORMATION ptDevInfo, CIFX_PACKET* ptPacket)
{
  return 0;
}

/*****************************************************************************/
/*! Get the actual DMA for a given device
*   \param ptDevInstance Device instance the trace is coming from
*   \param ulTraceLevel  TraceLevel the message is from
*   \param lError        Error code
*   \param szError       Error description (printf style format              */
/*****************************************************************************/
#ifdef CIFX_TOOLKIT_DMA
int USER_GetDMAMode( PCIFX_DEVICE_INFORMATION ptDevInfo)
{
  return 0;
}
#endif

/*****************************************************************************/
/*! Trace callbacks, used trace errors that may happen during device startup
*   right while cifXTKitAddDevice is being processed
*   \param ptDevInstance Device instance the trace is coming from
*   \param ulTraceLevel  TraceLevel the message is from
*   \param lError        Error code
*   \param szError       Error description (printf style format              */
/*****************************************************************************/
void USER_Trace(PDEVICEINSTANCE ptDevInstance, uint32_t ulTraceLevel,
                const char* szFormat, ...)
{
  va_list vaList;

  if(g_ulTraceLevel & ulTraceLevel)
  {
    va_start(vaList, szFormat);
    (void)vprintf(szFormat, vaList);
    va_end(vaList);
    printf("\r\n"); /*lint !e18 : 'printf' redeclared */
  }

  UNREFERENCED_PARAMETER(ptDevInstance);
} /*lint !e438 */

/*****************************************************************************/
/*! \}                                                                       */
/*****************************************************************************/
